definition module StdFontDef


//	********************************************************************************
//	Clean Standard Object I/O library, version 1.0.1
//	
//	StdFontDef contains the font definitions.
//	********************************************************************************


import StdInt, StdString


::	FontDef
	=	{	fName		:: !FontName	// Name of the font
		,	fStyles		:: ![FontStyle]	// Stylistic variations
		,	fSize		:: !FontSize	// Size in points
		}
::	FontMetrics
	=	{	fAscent		:: !Int			// Distance between top    and base line
		,	fDescent	:: !Int			// Distance between bottom and base line
		,	fLeading	:: !Int			// Distance between two text lines
		,	fMaxWidth	:: !Int			// Maximum character width including spacing
		}
::	FontName			:==	String
::	FontStyle			:==	String
::	FontSize			:==	Int


//	Font constants:

SerifFontDef			:==	{fName="Times",      fStyles=[],fSize=10}
SansSerifFontDef		:==	{fName="Arial",      fStyles=[],fSize=10}
SmallFontDef			:==	{fName="Small Fonts",fStyles=[],fSize=7 }
NonProportionalFontDef	:==	{fName="Courier",    fStyles=[],fSize=10}
SymbolFontDef			:==	{fName="Symbol",     fStyles=[],fSize=10}


//	Style constants:

ItalicsStyle			:== "Italic"
BoldStyle				:== "Bold"
UnderlinedStyle			:== "Underline"


//	Standard lineheight of a font is the sum of its leading, ascent and descent:
fontLineHeight fMetrics	:==	fMetrics.fLeading + fMetrics.fAscent + fMetrics.fDescent
